/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.mixin;

import com.redpxnda.nucleus.util.PlayerUtil;
import com.redpxnda.respawnobelisks.config.RespawnPerkConfig;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import com.redpxnda.respawnobelisks.util.ObeliskInventory;
import com.redpxnda.respawnobelisks.util.ObeliskUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    private static Random random = new Random();

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")})
    private void RESPAWNOBELISKS_preventEquipmentDrop(DamageSource damageSource, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof ServerPlayer) {
            RespawnObeliskBlockEntity be;
            ServerPlayer player = (ServerPlayer)livingEntityMixin;
            if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && player.m_8961_() != null && (livingEntityMixin = player.f_19853_.m_7702_(player.m_8961_())) instanceof RespawnObeliskBlockEntity && CoreUtils.hasInteraction((be = (RespawnObeliskBlockEntity)((Object)livingEntityMixin)).getCoreInstance(), ObeliskInteraction.SAVE_INV) && be.getCharge((Player)player) >= RespawnPerkConfig.minKeepItemCharge && (RespawnPerkConfig.allowCursedItemKeeping || !player.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get()))) {
                ObeliskInventory inventory;
                ObeliskInventory obeliskInventory = inventory = be.storedItems.containsKey(player.m_20148_()) ? be.storedItems.get(player.m_20148_()) : new ObeliskInventory();
                if (!player.m_217046_() && RespawnPerkConfig.Experience.keepExperience && inventory.xp <= 0) {
                    int rawXp = PlayerUtil.getTotalXp((Player)player);
                    inventory.xp = Mth.m_14107_((double)((double)rawXp * (RespawnPerkConfig.Experience.keepExperiencePercent / 100.0)));
                    if (RespawnPerkConfig.Experience.keepExperiencePercent >= 100.0) {
                        player.m_217045_();
                    } else {
                        player.m_6756_(-inventory.xp);
                    }
                }
                if (inventory.isArmorEmpty()) {
                    inventory.armor.clear();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(player.m_150109_().f_35975_.stream().map(i -> {
                        if (RespawnPerkConfig.Armor.keepArmor && (double)random.nextInt(100) <= RespawnPerkConfig.Armor.keepArmorChance - 1.0 || ObeliskUtils.shouldEnchantmentApply(i, random)) {
                            int index = player.m_150109_().f_35975_.indexOf(i);
                            player.m_150109_().f_35975_.set(index, (Object)ItemStack.f_41583_);
                            return i;
                        }
                        return ItemStack.f_41583_;
                    }).toList());
                    inventory.armor.addAll(stacks);
                }
                if (!player.m_21206_().m_41619_() && inventory.isOffhandEmpty()) {
                    inventory.offhand.clear();
                    if (RespawnPerkConfig.Offhand.keepOffhand && (double)random.nextInt(100) <= RespawnPerkConfig.Offhand.keepOffhandChance - 1.0 || ObeliskUtils.shouldEnchantmentApply(player.m_21206_(), random)) {
                        inventory.offhand.add(player.m_21206_());
                        player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                }
                if (inventory.isItemsEmpty()) {
                    inventory.items.clear();
                    boolean onlyHotbar = RespawnPerkConfig.Hotbar.keepHotbar && !RespawnPerkConfig.Inventory.keepInventory;
                    NonNullList rawStacks = onlyHotbar ? player.m_150109_().f_35974_.subList(0, 9) : player.m_150109_().f_35974_;
                    double chance = onlyHotbar ? RespawnPerkConfig.Hotbar.keepHotbarChance : RespawnPerkConfig.Inventory.keepInventoryChance;
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(rawStacks.stream().map(i -> {
                        if ((RespawnPerkConfig.Inventory.keepInventory || RespawnPerkConfig.Hotbar.keepHotbar) && (double)random.nextInt(100) <= chance || ObeliskUtils.shouldEnchantmentApply(i, random)) {
                            int index = player.m_150109_().f_35974_.indexOf(i);
                            player.m_150109_().f_35974_.set(index, (Object)ItemStack.f_41583_);
                            return i;
                        }
                        return ItemStack.f_41583_;
                    }).toList());
                    inventory.items.addAll(stacks);
                }
                be.storedItems.put(player.m_20148_(), inventory);
                be.syncWithClient();
            }
        }
    }
}

